<?php

$board = new MessageBoard();
$board->go();

class MessageBoard {
    protected $db;
    protected $form_errors = array();
    protected $inTransaction = false;
    
    public function __construct() {
        set_exception_handler(array($this,'logAndDie'));
        $this->db = new PDO('sqlite:/usr/local/message.db');
        $this->db->setAttribute(PDO::ATTR_ERRMODE,PDO::ERRMODE_EXCEPTION);
    }
    
    public function go() {
        // Od wartoci $_REQUEST['cmd'] zaley dalszy przebieg programu
        $cmd = isset($_REQUEST['cmd']) ? $_REQUEST['cmd'] : 'show';
        switch ($cmd) {
            case 'read':          // odczyt okrelonego komunikatu
              $this->read();
              break;
            case 'post':          // wywietlenie formularza przesania komunikatu
              $this->post();
              break;
            case 'save':          // zapisanie przesanego komunikatu
              if ($this->valid()) { // jeli komunikat jest poprawny,
                  $this->save();    // naley go zapisa
                  $this->show();    // i wywietli list komunikatw
              } else {
                  $this->post();    // w przeciwnym przypadku trzeba ponownie 
                                    // wywietli formularz
              }
              break;
            case 'show':          // wywietlenie listy komunikatw (domylne)
            default:
              $this->show();
              break;
        }
    }
    
    // Zapisanie wiadomoci w bazie danych
    protected function save() {
        
        $parent_id = isset($_REQUEST['parent_id']) ? 
                     intval($_REQUEST['parent_id']) : 0;

        // Tabela pc_message nie moe si zmieni w czasie wykonywania zadania.
        $this->db->beginTransaction();
        $this->inTransaction = true;

        // Czy wiadomo jest odpowiedzi na inny list?
        if ($parent_id) {
            // pobranie wartoci thread, level i thread_pos wiadomoci nadrzdnej 
            $st = $this->db->prepare("SELECT thread_id,level,thread_pos
                                FROM pc_message WHERE id = ?");
            $st->execute(array($parent_id));
            $parent = $st->fetch();

            // Poziom (level) odpowiedzi jest o jeden wikszy od poziomu wiadomoci
            // nadrzdnej
            $level = $parent['level'] + 1;

            */ Jaka jest najwysza warto thread_pos we wszystkich wiadomociach 
               wywodzcych si od jednej wiadomoci nadrzdnej? */
            $st = $this->db->prepare('SELECT MAX(thread_pos) FROM pc_message 
                    WHERE thread_id = ? AND parent_id = ?');
            $st->execute(array($parent['thread_id'], $parent_id));
            $thread_pos = $st->fetchColumn(0);

            // Czy s ju jakie odpowiedzi na ten list?
            if ($thread_pos) {
                // Warto thread_pos musi by o jeden wiksza od dotychczas najwikszej
                $thread_pos++;
            } else {
                // To jest pierwsza odpowied, naley j umieci zaraz za wiadomoci nadrzdn 
                $thread_pos = $parent['thread_pos'] + 1;
            }

            /* zwikszenie thread_pos we wszystkich wiadomociach wtku
               wystpujcych po tej wiadomoci */
            $st = $this->db->prepare('UPDATE pc_message SET thread_pos = thread_pos + 1 
                          WHERE thread_id = ? AND thread_pos >= ?');
            $st->execute(array($parent['thread_id'], $thread_pos));

            // Nowa wiadomo musi zosta zapisana z identyfikatorem 
            // wiadomoci nadrzdnej 
            $thread_id = $parent['thread_id'];
        } else {
            // Wiadomo nie jest odpowiedzi, zaczyna wic nowy wtek
            $thread_id = $this->db->query('SELECT MAX(thread_id) + 1 FROM pc_message')
                           ->fetchColumn(0);
            $level = 0;
            $thread_pos = 0;
        }
    
        /* Dodanie wiadomoci do bazy danych. Wykorzystanie metod prepare() i execute()
           zapewnia waciwe otoczenie wartoci pl znakami apostrofu */
        $st = $this->db->prepare("INSERT INTO pc_message (id,thread_id,parent_id,
                       thread_pos,posted_on,level,author,subject,body) 
                       VALUES (?,?,?,?,?,?,?,?,?)");

        $st->execute(array(null,$thread_id,$parent_id,$thread_pos,
                             date('c'),$level,$_REQUEST['author'],
                             $_REQUEST['subject'],$_REQUEST['body']));
                             
        // Zatwierdzenie wszystkich operacji
        $this->db->commit();
        $this->inTransaction = false;
    }

    // Wywietlenie listy wiadomoci
    protected function show() {
        print '<h2>Lista wiadomoci</h2><p>';

        /* Uoenie wiadomoci zgodnie z wartoci identyfikatora wtku 
           (thread_id) oraz wedug pozycji w wtku (thread_pos) */
        $st = $this->db->query("SELECT id,author,subject,LENGTH(body) AS body_length,
                       posted_on,level FROM pc_message
                       ORDER BY thread_id,thread_pos");
        while ($row = $st->fetch()) {
            // Wcinanie wiadomoci poziomu wyszego ni 0
            print str_repeat('&nbsp;',4 * $row['level']);
            // Wywietlenie informacji o wiadomoci wraz z odsyaczem do niej
            print "<a href='" . htmlentities($_SERVER['PHP_SELF']) .
            "?cmd=read&amp;id={$row['id']}'>" .
            htmlentities($row['subject']) . '</a> autor: ' .
            htmlentities($row['author']) . ' @ ' .
            htmlentities($row['posted_on']) .
            " ({$row['body_length']} bytes) <br/>";
        }

        // umoliwienie przesania wiadomoci niebdcej odpowiedzi
        print "<hr/><a href='" . 
              htmlentities($_SERVER['PHP_SELF']) .
              "?cmd=post'>Rozpocznij nowy wtek</a>";
    }
    
    // Wywietlenie wskazanej wiadomoci
    public function read() {
        
        /* Naley si upewni, e przekazany identyfikator wiadomoci jest liczb 
          cakowit i rzeczywicie reprezentuje wiadomo */
        if (! isset($_REQUEST['id'])) {
            throw new Exception('Nie podano identyfikatora wiadomoci');
        }
        $id = intval($_REQUEST['id']);
        $st = $this->db->prepare("SELECT author,subject,body,posted_on 
                                 FROM pc_message WHERE id = ?");
        $st->execute(array($id));
        $msg = $st->fetch();
        if (! $msg) {
            throw new Exception('Bad message ID');
        }

        /* Pominicie kodu HTML wprowadzonego przez uytkownika i doczenie
           znacznikw nowego wiersza waciwych dla dokumentu HTML*/
        $body = nl2br(htmlentities($msg['body']));

        // Wywietlenie wiadomoci z odsyaczami odpowiedzi i powrotu do 
        // listy wiadomoci 
        $self = htmlentities($_SERVER['PHP_SELF']);
        $subject = htmlentities($msg['subject']);
        $author = htmlentities($msg['author']);
        print<<<_HTML_
<h2>$subject</h2>
<h3>by $author</h3>
<p>$body</p>
<hr/>
<a href="$self?cmd=post&parent_id=$id">Reply</a>
<br/>
<a href="$self?cmd=list">Lista wiadomoci</a>
_HTML_;
    }

    // Wywietlenie formularza przesyania wiadomoci
    public function post() {
        $safe =  array();
        foreach (array('author','subject','body') as $field) {
            // Obsuga znakw specjalnych w domylnych wartociach pl
            if (isset($_POST[$field])) {
                $safe[$field] = htmlentities($_POST[$field]);
            } else {
                $safe[$field] = '';
            }
            // Wywietlenie komunikatw o bdach w kolorze czerwonym
            if (isset($this->form_errors[$field])) {
                $this->form_errors[$field] = '<span style="color: red">' . 
                   $this->form_errors[$field] . '</span><br/>';
            } else {
                $this->form_errors[$field] = '';
            }
        }

        // Czy ta wiadomo jest odpowiedzi na inny list?
        if (isset($_REQUEST['parent_id']) &&
        $parent_id = intval($_REQUEST['parent_id'])) { 

        // Warto parent_id musi by przesana wraz z formularzem
        $parent_field = 
            sprintf('<input type="hidden" name="parent_id" value="%d" />',
                    $parent_id);

        // Jeeli temat nie zosta okrelony, naley uy tematu wiadomoci nadrzdnej
        if (! strlen($safe['subject'])) {
             $st = $this->db->prepare('SELECT subject FROM pc_message WHERE id = ?');
             $st->execute(array($parent_id));
             $parent_subject = $st->fetchColumn(0);
                                       
            /* Dodanie prefiksu 'Odp:' do tematu wiadomoci nadrzdnej, jeli prefiks 
               ten nie wystpuje ju w temacie */
            $safe['subject'] = htmlentities($parent_subject);
            if ($parent_subject && (! preg_match('/^re:/i',$parent_subject))) {
                $safe['subject'] = "Re: {$safe['subject']}";
            }
          }
        } else {
            $parent_field = '';
        }
    

    // Wywietlenie formularza nowej wiadomoci wraz z komunikatami o bdach i
    // wartociami domylnymi
    $self = htmlentities($_SERVER['PHP_SELF']);
    print<<<_HTML_
<form method="post" action="$self">
<table>
<tr>
 <td>Nazwisko:</td>
 <td>{$this->form_errors['author']}
     <input type="text" name="author" value="{$safe['author']}" />
</td>
<tr>
 <td>Temat:</td>
 <td>{$this->form_errors['subject']}
     <input type="text" name="subject" value="{$safe['subject']}" />
</td>
<tr>
 <td>Wiadomo:</td>
 <td>{$this->form_errors['body']}
     <textarea rows="4" cols="30" wrap="physical" 
               name="body">{$safe['body']}</textarea>
</td>
<tr><td colspan="2"><input type="submit" value="Przelij wiadomo" /></td></tr>
</table>
$parent_field
<input type="hidden" name="cmd" value="save" />
</form>
_HTML_;
    }

    // Sprawdzenie, czy kade z pl zawiera jakkolwiek warto
    public function valid() {
        $this->form_errors = array();
        if (! (isset($_POST['author']) && strlen(trim($_POST['author'])))) {
            $this->form_errors['author'] = 'Muisz poda nazwisko.';
        }
        if (! (isset($_POST['subject']) && strlen(trim($_POST['subject'])))) {
            $this->form_errors['subject'] = 'Musisz poda temat wiadomoci.';
        }
        if (! (isset($_POST['body']) && strlen(trim($_POST['body'])))) {
            $this->form_errors['body'] = 'Musisz wprowadzi tre wiadomoci.';
        }

        return (count($this->form_errors) == 0);
    }

    public function logAndDie(Exception $e) {
        print 'ERROR: ' . htmlentities($e->getMessage());
        if ($this->db && $this->db->inTransaction) {
            $this->db->rollback();
        }
        exit();
    }
}
?>
